/* Intel Pentium-4 gmp-mparam.h -- Compiler/machine parameter header file.

Copyright 2019 Free Software Foundation, Inc.

This file is part of the GNU MP Library.

The GNU MP Library is free software; you can redistribute it and/or modify
it under the terms of either:

  * the GNU Lesser General Public License as published by the Free
    Software Foundation; either version 3 of the License, or (at your
    option) any later version.

or

  * the GNU General Public License as published by the Free Software
    Foundation; either version 2 of the License, or (at your option) any
    later version.

or both in parallel, as here.

The GNU MP Library is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received copies of the GNU General Public License and the
GNU Lesser General Public License along with the GNU MP Library.  If not,
see https://www.gnu.org/licenses/.  */

#define GMP_LIMB_BITS 32
#define GMP_LIMB_BYTES 4

/* 2600 MHz P4 Northwood */
/* FFT tuning limit = 23,700,309 */
/* Generated by tuneup.c, 2019-11-09, gcc 8.2 */

#define MOD_1_NORM_THRESHOLD                 5
#define MOD_1_UNNORM_THRESHOLD              14
#define MOD_1N_TO_MOD_1_1_THRESHOLD          7
#define MOD_1U_TO_MOD_1_1_THRESHOLD          5
#define MOD_1_1_TO_MOD_1_2_THRESHOLD        13
#define MOD_1_2_TO_MOD_1_4_THRESHOLD         0  /* never mpn_mod_1s_2p */
#define PREINV_MOD_1_TO_MOD_1_THRESHOLD      7
#define USE_PREINV_DIVREM_1                  1  /* native */
#define DIV_QR_1N_PI1_METHOD                 2  /* 4.36% faster than 1 */
#define DIV_QR_1_NORM_THRESHOLD             16
#define DIV_QR_1_UNNORM_THRESHOLD        MP_SIZE_T_MAX  /* never */
#define DIV_QR_2_PI2_THRESHOLD           MP_SIZE_T_MAX  /* never */
#define DIVEXACT_1_THRESHOLD                 0  /* always (native) */
#define BMOD_1_TO_MOD_1_THRESHOLD           21

#define DIV_1_VS_MUL_1_PERCENT             358

#define MUL_TOOM22_THRESHOLD                26
#define MUL_TOOM33_THRESHOLD               101
#define MUL_TOOM44_THRESHOLD               284
#define MUL_TOOM6H_THRESHOLD               406
#define MUL_TOOM8H_THRESHOLD               592

#define MUL_TOOM32_TO_TOOM43_THRESHOLD     101
#define MUL_TOOM32_TO_TOOM53_THRESHOLD     191
#define MUL_TOOM42_TO_TOOM53_THRESHOLD     189
#define MUL_TOOM42_TO_TOOM63_THRESHOLD     195
#define MUL_TOOM43_TO_TOOM54_THRESHOLD     151

#define SQR_BASECASE_THRESHOLD               0  /* always (native) */
#define SQR_TOOM2_THRESHOLD                 51
#define SQR_TOOM3_THRESHOLD                163
#define SQR_TOOM4_THRESHOLD                254
#define SQR_TOOM6_THRESHOLD                614
#define SQR_TOOM8_THRESHOLD                842

#define MULMID_TOOM42_THRESHOLD             58

#define MULMOD_BNM1_THRESHOLD               19
#define SQRMOD_BNM1_THRESHOLD               23

#define MUL_FFT_MODF_THRESHOLD             824  /* k = 5 */
#define MUL_FFT_TABLE3                                      \
  { {    824, 5}, {     29, 6}, {     15, 5}, {     33, 6}, \
    {     17, 5}, {     36, 6}, {     19, 5}, {     39, 6}, \
    {     29, 7}, {     15, 6}, {     32, 7}, {     17, 6}, \
    {     36, 7}, {     19, 6}, {     39, 7}, {     21, 6}, \
    {     43, 7}, {     23, 6}, {     48, 7}, {     29, 8}, \
    {     15, 7}, {     37, 8}, {     19, 7}, {     43, 8}, \
    {     23, 7}, {     49, 8}, {     27, 7}, {     55, 8}, \
    {     31, 7}, {     63, 8}, {     43, 9}, {     23, 8}, \
    {     55, 9}, {     31, 8}, {     67, 9}, {     39, 8}, \
    {     79, 9}, {     47, 8}, {     99, 9}, {     55,10}, \
    {     31, 9}, {     79,10}, {     47, 9}, {    103,11}, \
    {     31,10}, {     63, 9}, {    143,10}, {     79, 9}, \
    {    167,10}, {     95, 9}, {    191,10}, {    111,11}, \
    {     63,10}, {    127, 9}, {    255,10}, {    159,11}, \
    {     95,10}, {    191,12}, {     63,11}, {    127,10}, \
    {    271,11}, {    159,10}, {    319, 9}, {    639,10}, \
    {    335,11}, {    191,10}, {    383, 9}, {    799,10}, \
    {    415,11}, {    223,12}, {    127,11}, {    255,10}, \
    {    527,11}, {    287,10}, {    607, 9}, {   1215,11}, \
    {    319,10}, {    671,12}, {    191,11}, {    383,10}, \
    {    799,11}, {    415,10}, {    863,13}, {    127,12}, \
    {    255,11}, {    543,10}, {   1119, 9}, {   2239,11}, \
    {    607,10}, {   1215,12}, {    319,11}, {    671,10}, \
    {   1343,11}, {    735,10}, {   1471, 9}, {   2943,12}, \
    {    383,11}, {    799,10}, {   1599,11}, {    863,12}, \
    {    447,11}, {    927,10}, {   1855,11}, {    959,13}, \
    {    255,12}, {    511,11}, {   1119,12}, {    575,11}, \
    {   1215,10}, {   2431,11}, {   1247,12}, {    639,11}, \
    {   1343,12}, {    703,11}, {   1471,10}, {   2943,13}, \
    {    383,12}, {    767,11}, {   1599,12}, {    831,11}, \
    {   1727,10}, {   3455,12}, {    895,14}, {    255,13}, \
    {    511,12}, {   1087,11}, {   2239,10}, {   4479,12}, \
    {   1215,11}, {   2431,13}, {    639,12}, {   1343,11}, \
    {   2687,12}, {   1471,11}, {   2943,13}, {    767,12}, \
    {   1727,11}, {   3455,13}, {    895,12}, {   1983,14}, \
    {    511,13}, {   1023,12}, {   2239,13}, {   1151,12}, \
    {   2495,11}, {   4991,13}, {   1407,12}, {   2943,14}, \
    {    767,13}, {   1535,12}, {   3135,13}, {   1663,12}, \
    {   3455,13}, {   1919,12}, {   3967,15}, {    511,14}, \
    {   1023,13}, {   2175,12}, {   4479,13}, {   2431,12}, \
    {   4991,14}, {   1279,13}, {   2687,12}, {   5503,13}, \
    {   8192,14}, {  16384,15}, {  32768,16} }
#define MUL_FFT_TABLE3_SIZE 167
#define MUL_FFT_THRESHOLD                 7808

#define SQR_FFT_MODF_THRESHOLD             560  /* k = 5 */
#define SQR_FFT_TABLE3                                      \
  { {    560, 5}, {     33, 6}, {     17, 5}, {     35, 6}, \
    {     33, 7}, {     17, 6}, {     36, 7}, {     19, 6}, \
    {     39, 7}, {     35, 8}, {     19, 7}, {     43, 8}, \
    {     23, 7}, {     47, 8}, {     27, 7}, {     55, 8}, \
    {     31, 7}, {     63, 8}, {     43, 9}, {     23, 8}, \
    {     55, 9}, {     31, 8}, {     67, 9}, {     39, 8}, \
    {     79, 9}, {     47, 8}, {     95, 9}, {     55,10}, \
    {     31, 9}, {     79,10}, {     47, 9}, {     95,11}, \
    {     31,10}, {     63, 9}, {    135,10}, {     79, 9}, \
    {    159,10}, {    111,11}, {     63,10}, {    143, 9}, \
    {    287,10}, {    159,11}, {     95,10}, {    191,12}, \
    {     63,11}, {    127, 9}, {    511, 8}, {   1023, 9}, \
    {    527,11}, {    159,10}, {    319, 9}, {    639,10}, \
    {    351,11}, {    191,10}, {    431,11}, {    223,12}, \
    {    127,11}, {    255,10}, {    543,11}, {    287,10}, \
    {    607, 9}, {   1215,11}, {    319,10}, {    639,11}, \
    {    351,12}, {    191,11}, {    383,10}, {    767,11}, \
    {    415,10}, {    831,13}, {    127,12}, {    255,11}, \
    {    543,10}, {   1119,11}, {    607,12}, {    319,11}, \
    {    671,10}, {   1343,11}, {    735,12}, {    383,11}, \
    {    799,10}, {   1599,11}, {    863,12}, {    447,11}, \
    {    927,10}, {   1855,11}, {    991,13}, {    255,12}, \
    {    511,11}, {   1055,10}, {   2111,11}, {   1087,12}, \
    {    575,11}, {   1215,10}, {   2431,12}, {    639,11}, \
    {   1343,12}, {    703,11}, {   1407,13}, {    383,12}, \
    {    767,11}, {   1599,12}, {    831,11}, {   1727,10}, \
    {   3455,12}, {    895,11}, {   1855,12}, {    959,14}, \
    {    255,13}, {    511,12}, {   1087,11}, {   2239,12}, \
    {   1215,11}, {   2431,13}, {    639,12}, {   1471,11}, \
    {   2943,13}, {    767,12}, {   1727,11}, {   3455,13}, \
    {    895,12}, {   1983,14}, {    511,13}, {   1023,12}, \
    {   2239,13}, {   1151,12}, {   2495,11}, {   4991,13}, \
    {   1279,12}, {   2623,13}, {   1407,12}, {   2943,14}, \
    {    767,13}, {   1663,12}, {   3455,13}, {   1919,12}, \
    {   3839,15}, {    511,14}, {   1023,13}, {   2175,12}, \
    {   4479,13}, {   2431,12}, {   4991,14}, {   1279,13}, \
    {   2687,12}, {   5503,13}, {   8192,14}, {  16384,15}, \
    {  32768,16} }
#define SQR_FFT_TABLE3_SIZE 149
#define SQR_FFT_THRESHOLD                 4800

#define MULLO_BASECASE_THRESHOLD            12
#define MULLO_DC_THRESHOLD                  44
#define MULLO_MUL_N_THRESHOLD            14281
#define SQRLO_BASECASE_THRESHOLD            13
#define SQRLO_DC_THRESHOLD                  42
#define SQRLO_SQR_THRESHOLD               9449

#define DC_DIV_QR_THRESHOLD                 38
#define DC_DIVAPPR_Q_THRESHOLD             105
#define DC_BDIV_QR_THRESHOLD                52
#define DC_BDIV_Q_THRESHOLD                 83

#define INV_MULMOD_BNM1_THRESHOLD           50
#define INV_NEWTON_THRESHOLD               158
#define INV_APPR_THRESHOLD                 118

#define BINV_NEWTON_THRESHOLD              342
#define REDC_1_TO_REDC_N_THRESHOLD          67

#define MU_DIV_QR_THRESHOLD               2130
#define MU_DIVAPPR_Q_THRESHOLD            1895
#define MUPI_DIV_QR_THRESHOLD               60
#define MU_BDIV_QR_THRESHOLD              1652
#define MU_BDIV_Q_THRESHOLD               2089

#define POWM_SEC_TABLE  1,22,96,446,723,1378

#define GET_STR_DC_THRESHOLD                13
#define GET_STR_PRECOMPUTE_THRESHOLD        20
#define SET_STR_DC_THRESHOLD               298
#define SET_STR_PRECOMPUTE_THRESHOLD       960

#define FAC_DSC_THRESHOLD                  212
#define FAC_ODD_THRESHOLD                   71

#define MATRIX22_STRASSEN_THRESHOLD         26
#define HGCD2_DIV1_METHOD                    3  /* 0.68% faster than 1 */
#define HGCD_THRESHOLD                      80
#define HGCD_APPR_THRESHOLD                138
#define HGCD_REDUCE_THRESHOLD             4455
#define GCD_DC_THRESHOLD                   365
#define GCDEXT_DC_THRESHOLD                245
#define JACOBI_BASE_METHOD                   4  /* 23.41% faster than 1 */

/* Tuneup completed successfully, took 63807 seconds */
