/* gmp-mparam.h -- Compiler/machine parameter header file for a72.

Copyright 2019 Free Software Foundation, Inc.

This file is part of the GNU MP Library.

The GNU MP Library is free software; you can redistribute it and/or modify
it under the terms of either:

  * the GNU Lesser General Public License as published by the Free
    Software Foundation; either version 3 of the License, or (at your
    option) any later version.

or

  * the GNU General Public License as published by the Free Software
    Foundation; either version 2 of the License, or (at your option) any
    later version.

or both in parallel, as here.

The GNU MP Library is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received copies of the GNU General Public License and the
GNU Lesser General Public License along with the GNU MP Library.  If not,
see https://www.gnu.org/licenses/.  */

#define GMP_LIMB_BITS 64
#define GMP_LIMB_BYTES 8

/* 1800 MHz Cortex-A72 */
/* FFT tuning limit = 50,811,960 */
/* Generated by tuneup.c, 2019-10-22, gcc 7.3 */

#define DIVREM_1_NORM_THRESHOLD              3
#define DIVREM_1_UNNORM_THRESHOLD            3
#define MOD_1_1P_METHOD                      2  /* 12.09% faster than 1 */
#define MOD_1_NORM_THRESHOLD                 3
#define MOD_1_UNNORM_THRESHOLD               3
#define MOD_1N_TO_MOD_1_1_THRESHOLD          8
#define MOD_1U_TO_MOD_1_1_THRESHOLD          5
#define MOD_1_1_TO_MOD_1_2_THRESHOLD         0  /* never mpn_mod_1_1p */
#define MOD_1_2_TO_MOD_1_4_THRESHOLD        26
#define PREINV_MOD_1_TO_MOD_1_THRESHOLD     15
#define USE_PREINV_DIVREM_1                  1
#define DIV_QR_1N_PI1_METHOD                 1  /* 13.42% faster than 2 */
#define DIV_QR_1_NORM_THRESHOLD              4
#define DIV_QR_1_UNNORM_THRESHOLD            4
#define DIV_QR_2_PI2_THRESHOLD           MP_SIZE_T_MAX  /* never */
#define DIVEXACT_1_THRESHOLD                 0  /* always */
#define BMOD_1_TO_MOD_1_THRESHOLD           38

#define DIV_1_VS_MUL_1_PERCENT             168

#define MUL_TOOM22_THRESHOLD                 8
#define MUL_TOOM33_THRESHOLD                57
#define MUL_TOOM44_THRESHOLD               153
#define MUL_TOOM6H_THRESHOLD               222
#define MUL_TOOM8H_THRESHOLD               333

#define MUL_TOOM32_TO_TOOM43_THRESHOLD      57
#define MUL_TOOM32_TO_TOOM53_THRESHOLD     108
#define MUL_TOOM42_TO_TOOM53_THRESHOLD     104
#define MUL_TOOM42_TO_TOOM63_THRESHOLD      56
#define MUL_TOOM43_TO_TOOM54_THRESHOLD      82

#define SQR_BASECASE_THRESHOLD               0  /* always */
#define SQR_TOOM2_THRESHOLD                 16
#define SQR_TOOM3_THRESHOLD                 73
#define SQR_TOOM4_THRESHOLD                154
#define SQR_TOOM6_THRESHOLD                206
#define SQR_TOOM8_THRESHOLD                333

#define MULMID_TOOM42_THRESHOLD             18

#define MULMOD_BNM1_THRESHOLD                8
#define SQRMOD_BNM1_THRESHOLD               10

#define MUL_FFT_MODF_THRESHOLD             268  /* k = 5 */
#define MUL_FFT_TABLE3                                      \
  { {    268, 5}, {     11, 6}, {      6, 5}, {     13, 6}, \
    {     15, 7}, {     13, 8}, {      7, 7}, {     16, 8}, \
    {      9, 7}, {     19, 8}, {     11, 7}, {     23, 8}, \
    {     13, 9}, {      7, 8}, {     15, 7}, {     31, 8}, \
    {     19, 9}, {     11, 8}, {     27,10}, {      7, 9}, \
    {     15, 8}, {     33, 9}, {     19, 8}, {     39, 9}, \
    {     27,10}, {     15, 9}, {     39,10}, {     23, 9}, \
    {     51,11}, {     15,10}, {     31, 9}, {     71,10}, \
    {     39, 9}, {     79, 8}, {    159, 7}, {    319, 9}, \
    {     83,10}, {     47, 9}, {     95, 7}, {    383, 9}, \
    {     99,10}, {     55,11}, {     31,10}, {     63, 8}, \
    {    255, 7}, {    511, 9}, {    131,10}, {     71, 9}, \
    {    143, 8}, {    287, 7}, {    575, 6}, {   1151,10}, \
    {     79, 8}, {    319, 7}, {    639,10}, {     87, 8}, \
    {    351,11}, {     47,10}, {     95, 8}, {    383, 7}, \
    {    767,10}, {    103, 8}, {    415, 7}, {    831, 6}, \
    {   1663, 9}, {    223, 8}, {    447,12}, {     31,11}, \
    {     63, 9}, {    255, 8}, {    511, 7}, {   1023, 9}, \
    {    287, 8}, {    575, 7}, {   1151, 6}, {   2303, 7}, \
    {   1215,11}, {     79, 9}, {    319, 8}, {    639, 7}, \
    {   1279, 9}, {    351, 8}, {    703, 7}, {   1407, 6}, \
    {   2815, 9}, {    383, 8}, {    831, 7}, {   1663, 9}, \
    {    447, 8}, {    895, 7}, {   1791, 6}, {   3583, 8}, \
    {    959, 6}, {   3839, 5}, {   7679, 9}, {    511, 8}, \
    {   1023, 7}, {   2175, 9}, {    575, 8}, {   1151, 7}, \
    {   2303, 8}, {   1215,10}, {    351, 9}, {    703, 7}, \
    {   3071, 8}, {   1663, 9}, {    895, 8}, {   1791, 7}, \
    {   3583, 8}, {   1919, 6}, {   7679, 7}, {   3967, 9}, \
    {   1023,10}, {    575, 9}, {   1151, 8}, {   2559,10}, \
    {    703, 8}, {   2815, 9}, {   1471, 7}, {   5887,10}, \
    {    767,11}, {    415, 9}, {   1791, 8}, {   3583,11}, \
    {    479,10}, {    959, 8}, {   3967,11}, {    511, 9}, \
    {   2175,10}, {   1151, 8}, {   4607, 9}, {   2815,10}, \
    {   1471, 9}, {   2943,11}, {    767,10}, {   1535,11}, \
    {    831,10}, {   1791,11}, {    959,10}, {   1919, 9}, \
    {   3839, 8}, {   7679,10}, {   1983,12}, {    511,10}, \
    {   2047,11}, {   1215,12}, {    639,11}, {   1407,10}, \
    {   2815,11}, {   1471,12}, {    767,11}, {   1663,12}, \
    {    895,11}, {   1791,12}, {    959,11}, {   1919,10}, \
    {   3839,14}, {    255,13}, {    511,12}, {   1023,11}, \
    {   2047,12}, {   1215,13}, {    639,12}, {   1279,13}, \
    {    703,12}, {   1407,11}, {   2815,13}, {    767,12}, \
    {   1535,13}, {    831,12}, {   1663,13}, {    895,12}, \
    {   1791,11}, {   3583,13}, {    959,12}, {   1919,11}, \
    {   3839,14}, {    511,13}, {   1023,12}, {   2047,13}, \
    {   1215,12}, {   2431,14}, {    639,13}, {   1407,12}, \
    {   2815,13}, {   1471,12}, {   2943,14}, {    767,13}, \
    {   1535,12}, {   3071,13}, {   1791,12}, {   3583,13}, \
    {   1919,14}, {   1023,13}, {   2175,14}, {   1151,13}, \
    {   2431,14}, {   1279,13}, {   2559,15}, {    767,14}, \
    {   1791,13}, {   3839,15}, {   1023,14}, {   2431,13}, \
    {   4863,15}, {   1279,14}, {   2943,15}, {   1535,14}, \
    {  16384,15}, {  32768,16}, {  65536,17}, { 131072,18}, \
    { 262144,19}, { 524288,20}, {1048576,21}, {2097152,22}, \
    {4194304,23}, {8388608,24} }
#define MUL_FFT_TABLE3_SIZE 218
#define MUL_FFT_THRESHOLD                 2688

#define SQR_FFT_MODF_THRESHOLD             236  /* k = 5 */
#define SQR_FFT_TABLE3                                      \
  { {    236, 5}, {     13, 6}, {      7, 5}, {     15, 6}, \
    {     15, 7}, {      8, 6}, {     17, 7}, {     13, 8}, \
    {      7, 7}, {     17, 8}, {      9, 7}, {     20, 8}, \
    {     11, 7}, {     23, 8}, {     13, 9}, {      7, 8}, \
    {     19, 9}, {     11, 8}, {     25,10}, {      7, 9}, \
    {     15, 8}, {     33, 9}, {     19, 8}, {     39, 9}, \
    {     27,10}, {     15, 9}, {     39,10}, {     23, 9}, \
    {     47,11}, {     15,10}, {     31, 9}, {     67,10}, \
    {     39, 9}, {     79, 8}, {    159,10}, {     47, 9}, \
    {     95, 8}, {    191, 7}, {    383,10}, {     55,11}, \
    {     31,10}, {     63, 9}, {    127, 8}, {    255, 7}, \
    {    511,10}, {     71, 9}, {    143, 8}, {    287, 7}, \
    {    575,10}, {     79, 8}, {    319, 7}, {    639,11}, \
    {     47,10}, {     95, 8}, {    383, 7}, {    767, 8}, \
    {    415,12}, {     31,11}, {     63,10}, {    127, 9}, \
    {    255, 8}, {    543, 9}, {    287, 8}, {    575, 7}, \
    {   1151, 9}, {    319, 8}, {    639, 9}, {    351, 8}, \
    {    703, 7}, {   1407, 6}, {   2815,10}, {    191, 9}, \
    {    383, 8}, {    767, 9}, {    415, 8}, {    831, 7}, \
    {   1663,10}, {    223, 9}, {    447, 8}, {    895, 7}, \
    {   1791, 9}, {    479, 8}, {    959,12}, {     63,11}, \
    {    127, 9}, {    543, 8}, {   1087,10}, {    287, 9}, \
    {    575, 8}, {   1151,10}, {    319, 9}, {    639,10}, \
    {    351, 9}, {    703, 8}, {   1407, 7}, {   2815, 8}, \
    {   1471, 5}, {  11775, 9}, {    767, 8}, {   1535,10}, \
    {    415, 9}, {    895, 8}, {   1919, 6}, {   7679, 7}, \
    {   3967,11}, {    255,10}, {    543, 9}, {   1087, 8}, \
    {   2175,10}, {    575, 9}, {   1151, 8}, {   2431,10}, \
    {    639, 9}, {   1279,10}, {    703, 9}, {   1407, 8}, \
    {   2943,11}, {    383,10}, {    767,11}, {    447,10}, \
    {    895,11}, {    479,10}, {    959, 9}, {   1919, 8}, \
    {   3839,10}, {   1023, 9}, {   2175,10}, {   1215, 9}, \
    {   2431,11}, {    703, 9}, {   2815,10}, {   1471,11}, \
    {    767,10}, {   1663,11}, {    895,10}, {   1791,11}, \
    {    959, 9}, {   3839,12}, {    511,11}, {   1087,10}, \
    {   2175,11}, {   1215,10}, {   2431,12}, {    639,11}, \
    {   1279,12}, {    703,11}, {   1471,12}, {    767,11}, \
    {   1663,12}, {    895,11}, {   1919,10}, {   3839,13}, \
    {    511,12}, {   1087,11}, {   2175,12}, {   1215,11}, \
    {   2431,13}, {    639,12}, {   1279,13}, {    703,12}, \
    {   1407,13}, {    767,12}, {   1535,13}, {    831,12}, \
    {   1791,13}, {   1151,12}, {   2303,13}, {   1215,14}, \
    {    639,12}, {   2559,13}, {   1407,14}, {    767,12}, \
    {   3071,14}, {    895,13}, {   1919,12}, {   3839,14}, \
    {   1023,13}, {   2175,14}, {   1151,12}, {   4607,14}, \
    {   1279,13}, {   2559,14}, {   1407,13}, {   2943,15}, \
    {    767,14}, {   1663,13}, {   3583,14}, {   1919,15}, \
    {   1023,14}, {   2047,13}, {   4095,14}, {   2943,15}, \
    {   1535,14}, {  16384,15}, {  32768,16}, {  65536,17}, \
    { 131072,18}, { 262144,19}, { 524288,20}, {1048576,21}, \
    {2097152,22}, {4194304,23}, {8388608,24} }
#define SQR_FFT_TABLE3_SIZE 203
#define SQR_FFT_THRESHOLD                 2176

#define MULLO_BASECASE_THRESHOLD             0  /* always */
#define MULLO_DC_THRESHOLD                  33
#define MULLO_MUL_N_THRESHOLD             5240
#define SQRLO_BASECASE_THRESHOLD             6
#define SQRLO_DC_THRESHOLD                  45
#define SQRLO_SQR_THRESHOLD               4265

#define DC_DIV_QR_THRESHOLD                 38
#define DC_DIVAPPR_Q_THRESHOLD             108
#define DC_BDIV_QR_THRESHOLD                36
#define DC_BDIV_Q_THRESHOLD                 71

#define INV_MULMOD_BNM1_THRESHOLD           14
#define INV_NEWTON_THRESHOLD               132
#define INV_APPR_THRESHOLD                 124

#define BINV_NEWTON_THRESHOLD              199
#define REDC_1_TO_REDC_N_THRESHOLD          34

#define MU_DIV_QR_THRESHOLD                979
#define MU_DIVAPPR_Q_THRESHOLD             979
#define MUPI_DIV_QR_THRESHOLD               61
#define MU_BDIV_QR_THRESHOLD               734
#define MU_BDIV_Q_THRESHOLD                942

#define POWM_SEC_TABLE  6,30,110,579,1730

#define GET_STR_DC_THRESHOLD                12
#define GET_STR_PRECOMPUTE_THRESHOLD        19
#define SET_STR_DC_THRESHOLD               458
#define SET_STR_PRECOMPUTE_THRESHOLD       875

#define FAC_DSC_THRESHOLD                  153
#define FAC_ODD_THRESHOLD                   24

#define MATRIX22_STRASSEN_THRESHOLD         15
#define HGCD2_DIV1_METHOD                    1  /* 8.41% faster than 3 */
#define HGCD_THRESHOLD                      81
#define HGCD_APPR_THRESHOLD                 80
#define HGCD_REDUCE_THRESHOLD             1494
#define GCD_DC_THRESHOLD                   268
#define GCDEXT_DC_THRESHOLD                189
#define JACOBI_BASE_METHOD                   1  /* 10.80% faster than 4 */

/* Tuneup completed successfully, took 96906 seconds */
