#include "testutils.h"
#include "nettle-internal.h"

void
test_main(void)
{
  /* From the EAX specification,
     http://www.cs.ucdavis.edu/~rogaway/papers/eax.pdf */
  test_aead(&nettle_eax_aes128, NULL,
	    SHEX("233952DEE4D5ED5F9B9C6D6FF80FF478"),	/* key */
	    SHEX("6BFB914FD07EAE6B"),			/* auth data */
	    SHEX(""),					/* plaintext */
	    SHEX(""),					/* ciphertext */
	    SHEX("62EC67F9C3A4A407FCB2A8C49031A8B3"),	/* nonce */
	    SHEX("E037830E8389F27B025A2D6527E79D01"));	/* tag */

  test_aead(&nettle_eax_aes128, NULL,
	    SHEX("91945D3F4DCBEE0BF45EF52255F095A4"),
	    SHEX("FA3BFD4806EB53FA"),
	    SHEX("F7FB"),
	    SHEX("19DD"),
	    SHEX("BECAF043B0A23D843194BA972C66DEBD"),
	    SHEX("5C4C9331049D0BDAB0277408F67967E5"));
  
  test_aead(&nettle_eax_aes128, NULL,
	    SHEX("01F74AD64077F2E704C0F60ADA3DD523"),
	    SHEX("234A3463C1264AC6"),
	    SHEX("1A47CB4933"),
	    SHEX("D851D5BAE0"),
	    SHEX("70C3DB4F0D26368400A10ED05D2BFF5E"),
	    SHEX("3A59F238A23E39199DC9266626C40F80"));

  test_aead(&nettle_eax_aes128, NULL,
	    SHEX("D07CF6CBB7F313BDDE66B727AFD3C5E8"),
	    SHEX("33CCE2EABFF5A79D"),
	    SHEX("481C9E39B1"),
	    SHEX("632A9D131A"),
	    SHEX("8408DFFF3C1A2B1292DC199E46B7D617"),
	    SHEX("D4C168A4225D8E1FF755939974A7BEDE"));

  test_aead(&nettle_eax_aes128, NULL,
	    SHEX("35B6D0580005BBC12B0587124557D2C2"),
	    SHEX("AEB96EAEBE2970E9"),
	    SHEX("40D0C07DA5E4"),
	    SHEX("071DFE16C675"),
	    SHEX("FDB6B06676EEDC5C61D74276E1F8E816"),
	    SHEX("CB0677E536F73AFE6A14B74EE49844DD"));

  test_aead(&nettle_eax_aes128, NULL,
	    SHEX("BD8E6E11475E60B268784C38C62FEB22"),
	    SHEX("D4482D1CA78DCE0F"),
	    SHEX("4DE3B35C3FC039245BD1FB7D"),
	    SHEX("835BB4F15D743E350E728414"),
	    SHEX("6EAC5C93072D8E8513F750935E46DA1B"),
	    SHEX("ABB8644FD6CCB86947C5E10590210A4F"));

  test_aead(&nettle_eax_aes128, NULL,
	    SHEX("7C77D6E813BED5AC98BAA417477A2E7D"),
	    SHEX("65D2017990D62528"),
	    SHEX("8B0A79306C9CE7ED99DAE4F87F8DD61636"),
	    SHEX("02083E3979DA014812F59F11D52630DA30"),
	    SHEX("1A8C98DCD73D38393B2BF1569DEEFC19"),
	    SHEX("137327D10649B0AA6E1C181DB617D7F2"));
  
  test_aead(&nettle_eax_aes128, NULL,
	    SHEX("5FFF20CAFAB119CA2FC73549E20F5B0D"),
	    SHEX("54B9F04E6A09189A"),
	    SHEX("1BDA122BCE8A8DBAF1877D962B8592DD2D56"),
	    SHEX("2EC47B2C4954A489AFC7BA4897EDCDAE8CC3"),
	    SHEX("DDE59B97D722156D4D9AFF2BC7559826"),
	    SHEX("3B60450599BD02C96382902AEF7F832A"));
  
  test_aead(&nettle_eax_aes128, NULL,
	    SHEX("A4A4782BCFFD3EC5E7EF6D8C34A56123"),
	    SHEX("899A175897561D7E"),
	    SHEX("6CF36720872B8513F6EAB1A8A44438D5EF11"),
	    SHEX("0DE18FD0FDD91E7AF19F1D8EE8733938B1E8"),
	    SHEX("B781FCF2F75FA5A8DE97A9CA48E522EC"),
	    SHEX("E7F6D2231618102FDB7FE55FF1991700"));
  
  test_aead(&nettle_eax_aes128, NULL,
	    SHEX("8395FCF1E95BEBD697BD010BC766AAC3"),
	    SHEX("126735FCC320D25A"),
	    SHEX("CA40D7446E545FFAED3BD12A740A659FFBBB3CEAB7"),
	    SHEX("CB8920F87A6C75CFF39627B56E3ED197C552D295A7"),
	    SHEX("22E7ADD93CFC6393C57EC0B3C17D6B44"),
	    SHEX("CFC46AFC253B4652B1AF3795B124AB6E"));
}
